/*  *********************************************************
	*           PVX PLUS PROPRIETARY & SENSITIVE            *
	* ----------------------------------------------------- *
	*  The information contained herein is the exclusive    *
	*  property of PVX Plus Technologies Ltd (Ontario).     *
	*  This material shall not be reproduced, or its        *
	*  contents disclosed to others in whole or in part.    *
	* ----------------------------------------------------- *
	*   Copyright (c) 2011                                  *
	*            PVX Plus Technologies (Ontario, Canada)    *
	********************************************************* */

/* Sybex.h -- Generic definitions To allow migration to Compilers without prototyping */

#if defined(SYBEX_H)
#else
#define SYBEX_H

#define Void			void

#if defined(_UNIX_)
#	define APIDEF
#else
#if !defined(_WIN32_WINNT)
#	define _WIN32_WINNT 0x0500
#endif
#	include <windows.h>
#	ifndef RC_INVOKED
#		include <windowsx.h>
#		include <string.h>
#	endif
#	define APIDEF WINAPI
#endif

#define EQ ==
#define NE !=
#define AND	&&
#define OR	||

#define ON(a,b)         (( (a) & (b) ) != 0)
#define OFF(a,b)        (( (a) & (b) ) == 0)

#define SETON(a,b)      a |= (b)
#define SETOFF(a,b)     a &= ~(b)/*a &= (0xFFFF ^ (b))*/

#define IFON(a,b)     	if ( (a) & (b) )
#define IFOFF(a,b)    	if (((a) & (b)) == 0)

#define IFNZ(a)			if ( (a) != 0 )

#define IFZ_LONG(a)		if (((a)[0] | (a)[1] | (a)[2] | (a)[3]) EQ 0)
#define IFNZ_LONG(a)	if (((a)[0] | (a)[1] | (a)[2] | (a)[3]) NE 0)

#define CLR_LONG(a)		((a)[0] = (a)[1] = (a)[2] = (a)[3] = 0)
#define MVE_LONG(a,b)	((a)[0] = (b)[0], (a)[1] = (b)[1], \
						 (a)[2] = (b)[2], (a)[3] = (b)[3])

#define TRUE 1
#define FALSE 0

typedef short int				INT16;
typedef unsigned short int		UINT16;
#if !defined(_BASETSD_H_) /* BaseTsd.h is msft header with basic types */
#include <stdint.h>
typedef int32_t			    	INT32;
typedef uint32_t	    	    UINT32;
/*typedef unsigned char           UCHAR;*/
#   ifdef SUPPORT_64BIT_LFS 
#		ifdef WIN32
		typedef __int64             INT64;
		typedef unsigned __int64    UINT64;
#		else
		typedef long long           INT64;
		typedef unsigned long long  UINT64;
#		endif
#	endif
#endif

/* The remote IO uses pointers as handles which means for 64-bit compiles this
    conversion is needed as you cannot normal put a 64-bit value in a 32-bit
    variable. In our case this is OK to do because the pointers when passed
    through the remote interface are only used to uniquely identify a open file
    or a session and not as memory addresses. It is possible that we could get
    two pointers that have the same 32-bit lower half and this would cause
    problems but it is such an unlikely possibility that we don't worry about
    it. In a perfect world we could pass this as 64-bit but for compatability we
    don't want to change the protocol. */
#define CONVERT_HANDLE_FOR_RMT(handle)  (SAFE_POINTER_CAST(INT32, handle))
#define CONVERT_HANDLE_FROM_RMT(handle) (SAFE_POINTER_CAST(void *, handle))

/* This is the more generic safe pointer cast macro used in a few places were
   the cast was deemed safe. */
#define SAFE_POINTER_CAST(type, value)  ((type)((intptr_t)value))

#if defined(_UNIX_)
#define BOOL	int
#endif

typedef unsigned char 	byte;

#define INT16_SZ 	2
#define INT32_SZ 	4
#define INT64_SZ 	8

#define _UIB(a)  		((unsigned short int)((byte)a))
#define GT_INT16(a, b)	a = (_UIB(b[0]) << 8) | _UIB(b[1])

#define _ULB(a)  		((unsigned long int)((byte)a))
#define GT_INT32(a,b) 	a = (_ULB(b[0]) << 24) | (_ULB(b[1]) << 16) | (_ULB(b[2]) << 8) | _ULB(b[3])
#define GT_SWP_INT32(a,b) 	a = (_ULB(b[3]) << 24) | (_ULB(b[2]) << 16) | (_ULB(b[1]) << 8) | _ULB(b[0])

#define ST_INT16(a,b)   ((byte *)a)[1] = (byte)(b & 0xFF), ((byte *)a)[0] = (byte)((b >> 8) & 0xFF)
#define ST_INT32(a,b)   ((byte *)a)[3] = (byte)(b & 0xFF), \
                        ((byte *)a)[2] = (byte)((b >> 8) & 0xFF), \
                        ((byte *)a)[1] = (byte)((b >> 16) & 0xFF), \
                        ((byte *)a)[0] = (byte)((b >> 24) & 0xFF)

#define ST_SWP_INT32(a,b)   ((byte *)a)[0] = (byte)(b & 0xFF), \
							((byte *)a)[1] = (byte)((b >> 8) & 0xFF), \
							((byte *)a)[2] = (byte)((b >> 16) & 0xFF), \
							((byte *)a)[3] = (byte)((b >> 24) & 0xFF)
/* This struct is for compatability with platforms that do not have 64 bit long */
typedef struct LL_t{
	INT32  h;
	UINT32 l;
} LL;

#define GT_INT64(a,b) (GT_INT32((a).h,(&(b)[0])),GT_INT32((a).l,(&(b)[4])))
#define ST_INT64(a,b) (ST_INT32((&(a)[0]),(b).h),ST_INT32((&(a)[4]),(b).l))
#define LL2INT64(a,b) (b=(INT64)(((INT64)((a).l)&0x00000000FFFFFFFF)|((INT64)((a).h))<<32))
#define INT642LL(a,b) ((b).l=((a)&0xFFFFFFFF),(b).h=(((a) >> 32) & 0xFFFFFFFF))
#define HI_INT64(a) ((a).h)
#define LO_INT64(a) ((a).l)
#define INC_INT64(a) if((a).l!=0xFFFFFFFF)(a).l++;else{(a).h++;(a).l=0;}
#define DEC_INT64(a) if((a).l!=0)(a).l--;else{(a).h--;(a).l=0xFFFFFFFF;}
#define GT_INT64to32(a,b) GT_INT32((a),(&(b)[4]))

#if defined(WIN32)
#define __func__ __FUNCTION__
#elif defined(__SCOUNX__)
#define __func__ ""
#endif

#endif


#ifdef _UNIX_
#	ifdef __LINUX__
#		define __Ix86__
#	endif
#	ifdef __SCOUNX__
#		define __Ix86__
#	endif
#	ifdef __SCO6__
#		define __Ix86__
#	endif
#	ifdef __IBMR6K__
#		define __M68K__
#	endif
#	ifdef __SUN__
#		define __M68K__
#	endif
#else
#	define __Ix86__
#endif


#if defined(__Ix86__)

#define GT_INT(a,b)			( (a) = (((char *)(b))[0] << 8) | (((unsigned char *)(b))[1]) )

#define ST_INT(a,b)         ( (a)[0] = ((b) >> 8) & 0xFF, \
							  (a)[1] = (b) & 0xFF )
#endif


#if defined(__M68K__)
							/* 010921 - Added 'signed' to GT_INT to resolve WindX issues on AIX (couldn't UNIX2DOS.WDX) */
#define GT_INT(a,b)			( (a) = (((signed char *)(b))[0] << 8) | (((unsigned char *)(b))[1]) )

#define ST_INT(a,b)         ( (a)[0] = ((b) >> 8) & 0xFF, \
							  (a)[1] = (b) & 0xFF )
#endif
