/*  *********************************************************
	*           PVX PLUS PROPRIETARY & SENSITIVE            *
	* ----------------------------------------------------- *
	*  The information contained herein is the exclusive    *
	*  property of PVX Plus Technologies Ltd (Ontario).     *
	*  This material shall not be reproduced, or its        *
	*  contents disclosed to others in whole or in part.    *
	* ----------------------------------------------------- *
	*   Copyright (c) 2011                                  *
	*            PVX Plus Technologies (Ontario, Canada)    *
	********************************************************* */

#if defined(_PVXSHARE_H_)
#else
#define _PVXSHARE_H_	1

#include "sybex.h"

#if defined(WIN32)
#include <windows.h>
#endif
 
#define Toupper(a)		Uppercs[(byte)(a)]
#define Tolower(a)		Lowercs[(byte)(a)]

#if defined(PVK_LINUX)
#	define _snprintf snprintf
#	define stricmp strcasecmp
#elif defined(__IBMR6K__)
#	define _snprintf snprintf
#	define stricmp strcasecmp
#elif defined(__SCOUNX__) || defined(__SCO6__)
#	define _memcmp memcmp
#	define stricmp strcasecmp
#elif defined(__SUN__)
#	define _snprintf snprintf
#	define _memcmp memcmp
#	define stricmp strcasecmp
#endif

#ifdef _UNIX_
#if defined(PVK_LINUX)
#   define STRNICMP strncasecmp
#elif defined(__IBMR6K__)
#   define STRNICMP strnicmp
#elif defined(__SCOUNX__) || defined(__SCO6__)
#   define STRNICMP strnicmp
#elif defined(__SUN__)
#   define STRNICMP strnicmp
#endif
#define STRNCMP strncmp /* Case sensitive comparison on UNIX */
#else
#define STRNICMP strnicmp
#define STRNCMP strncmp
#endif 

#if defined(WIN32)
#if defined(SUPPORT_64BIT_LFS)
#define PX_STAT  _stat64
#define PX_FSTAT _fstat64
#define STAT_ST   struct __stat64
#else
#define PX_STAT  stat
#define PX_FSTAT fstat
#define STAT_ST   struct stat
#endif
#else
#if defined(SUPPORT_64BIT_LFS)
#define PX_STAT  stat64
#define PX_FSTAT fstat64
#define STAT_ST   struct stat64
#else
#define PX_STAT  stat
#define PX_FSTAT fstat
#define STAT_ST   struct stat
#endif
#endif

#if defined(WIN32)
#	define LSEEK64 _lseeki64
#else
#	define LSEEK64 lseek64
#endif

#ifdef _UNIX_
#include "unixdefs.h"
#endif

#define WIN2UNIX_SLASH(p) { \
		int i; for(i=0;i<(int)strlen(p);i++){ \
			if(p[i]=='\\')p[i]='/'; \
		} \
	}

/* restrictions related */
#define OP_NUM_TEST 0x8000
#define OP_DATE_TEST 0x10000
#define PVX_DBL_ROUND_ERR (0.00000000000001)

/* Maximum sizes */
#define BFR_SIZE (64*1024-32)

#define MAX_ACCESSFLAG_LENGTH		1
#define MAX_BINARY_LITERAL_LENGTH	255
#define MAX_CATALOG_NAME_LENGTH		255
#define MAX_NUM_CATALOGS			256
#define MAX_CHAR_WRK_BUF			32766
#define MAX_CLASS_LENGTH			31	/* needs to be same as value used by nomads +1 for null */
#define MAX_CLIENT_IP_NAME			127
#define MAX_COLUMN_NAME_LENGTH		63
#define MAX_COLUMN_FORMAT_LENGTH	63
#define MAX_COLUMN_OCCURS_LENGTH	10
#define MAX_COLUMN_DEFAULT_LENGTH	80
#define MAX_COLUMN_TAG_LENGTH		250
#define MAX_COLUMN_VALIDATE_LENGTH	40
#define MAX_COLUMN_MUSTBE_LENGTH	63
#define MAX_COLUMN_RECTYPE_LENGTH	63
#define MAX_COLUMN_SAMEAS_LENGTH	63
#define MAX_COLUMNS_IN_ORDER_BY		20
#define MAX_COLUMNS_IN_INDEX		15
#define MAX_COLUMNS_IN_KEY			15
#define MAX_COMMAND_LINE			255
#define MAX_COMPANY_CODE_LENGTH		127
#define MAX_DDF_CLASS				30	/* same as MAX_CLASS_LENGTH without the + 1 */
#define MAX_DDF_COLUMN_NAME			MAX_COLUMN_NAME_LENGTH
#define MAX_DDF_DESCRIPTION			80
#define MAX_DDF_IOPROG				80
#define MAX_DDF_GROUP				15
#define MAX_DDF_PHYSICAL			MAX_DIRECTORY_NAME_LENGTH + MAX_TABLE_NAME_LENGTH + MAX_SESSIONID_LENGTH
#define MAX_DDF_SECURITY			80
#define MAX_ERR_MSG_LENGTH			1024
#define MAX_CURSOR_NAME_LENGTH		19
#define MAX_DATABASE_NAME_LENGTH	127
#define MAX_DEFAULT_LENGTH			255
#define MAX_DIRECTORY_NAME_LENGTH	127
#define MAX_DRIVER_LENGTH			255
#define MAX_DRIVER_NAME_LENGTH		63
#define MAX_EXECUTABLE_NAME			64
#define MAX_EXTERNALKEY_SIZE		127
#define MAX_FILE_NAME				255
#define MAX_HOST_NAME_LENGTH		63
#define MAX_INDEX_NAME_LENGTH		63
#define MAX_INI_BUFFER				(64*1024) - 32 /* 010203 Changed from 65535 to satisfy Win98 limitation */
#define MAX_INI_FILE_NAME_LENGTH	127
#define MAX_ISAM_NAME_LENGTH		31
#define MAX_KEY_LENGTH				256
#define MAX_KEY_NAME_LENGTH			63
#define MAX_KEY_SIZE				(240 + 1)  /* Was 127, should be 240 + 1 for 0x00 */
#define MAX_LOGFILE_LENGTH			127
#define MAX_PASSWORD_LENGTH			63
#define MAX_PATH_LENGTH				256
#define MAX_PATHNAME_SIZE			255
#define MAX_PERMISSION_LENGTH		1024
#define MAX_PORT_LENGTH				5
#define MAX_PORT_NUMBER_LENGTH		15
#define MAX_PREFIX_LENGTH			1023
#define MAX_PVK_HOST_LENGTH			100
#define MAX_PVK_PORT_LENGTH			15
#define MAX_PVK_PREFIX				1024
#define MAX_RESTRICTIONS			50
#define MAX_RETRIES					40
#define MAX_RW_LENGTH				2
#define MAX_SCALAR_ARGS				256
#define MAX_SESSIONID_LENGTH		15
#define MAX_SCHEMA_LENGTH			127
#define MAX_STATUS_PROCESS_INFO		1024
#define MAX_TABLE_NAME_LENGTH		64	/* Increased from 63 for compatibility with Pvx 7.0 */
#define MAX_TCP_MTU					64 /* 1500 - over 128kbps, 576 - dialup */
#define MAX_TCP_ZLIB				1024 /* zlib threshold */
#define MAX_TOKEN_SIZE				255 /* Was MAX_CHAR_LITERAL_LENGTH. Changed to eliminate a stack overflow problem in Office97 */
#define MAX_USER_ERR_MSG			255	/* szErrMsg - User supplied error text */
#define MAX_USER_LICENSE_NUMBER		1024
#define MAX_USER_NAME_LENGTH		64
#define MAX_VERSION_NAME_LENGTH		15
#define MAX_VIEW_DIR				256
#define MAX_VIEWDLL					256
#define MAX_VIEWDLL_LENGTH			127
#define MAX_CATALOG_LENGTH			1 + MAX_DIRECTORY_NAME_LENGTH + 2 + MAX_INI_FILE_NAME_LENGTH + 2 + MAX_PREFIX_LENGTH + 1

#define MAX_CHAR_LITERAL_LENGTH		MAX_CHAR_WRK_BUF /* 255 */
#define MAX_COLUMNS_IN_GROUP_BY		MAX_COLUMNS_IN_ORDER_BY
#define MAX_COMPANYCODE				MAX_COMPANY_CODE_LENGTH
#define MAX_DD_PATH					MAX_DIRECTORY_NAME_LENGTH
#define MAX_INI_PATH				MAX_INI_FILE_NAME_LENGTH
#define MAX_RMT_FILE_NAME			MAX_FILE_NAME+MAX_DIRECTORY_NAME_LENGTH+MAX_HOST_NAME_LENGTH+5+1+7
#define MAX_USRID					MAX_USER_NAME_LENGTH

#define PVK_MIN_BULK_RECNO 1
#define PVK_MAX_BULK_RECNO 200
#define PVK_MAX_CACHE_SZ  (10*1024*1024)
#define PVX_MAX_RECS_FILE_CACHE 3000 /* 100 */


/* Defines for security dll logon */
#define PVLOGON_ERR			 0
#define PVLOGON_OK			 1
#define PVLOGON_NEEDMOREINFO 2
#define MAX_ATTEMPTS		 10

/* Silent mode flags */
#define SILENT_NO		0		/* display error, warning or prompts to the user - no silent mode */
#define SILENT_YES		1		/* return immediately without user interaction - silence enforced */
#define SILENT_SVR_YES	2		/* server-side processing, no UI */
#define SILENT_CLN_NO	4		/* client-side processing, UI allowed */
#define SILENT_CLN_YES	8		/* client-side processing, no UI */

/* Error codes generated by the server and reported by the client */
#define ISAM_LICENSE_ERROR		-2
#define ISAM_SECURITY_ERROR		-3

/* Handshake defines */
#define HS_DEBUG_MODE		1
#define HS_COMPRESSION_STD	0	/* character-like compression */
#define HS_COMPRESSION_ZLIB	100 /* ZLib compression */

#define NO_KEY_SEEK_TO_BEG -1
#define GET_KEY_SZ(key_sz) (((key_sz) == NO_KEY_SEEK_TO_BEG) ? 0 : (key_sz))

int pvx_atod (char *no_in, size_t len, double *val);

BOOL ResolvePath (char *strBaseDirectory, size_t lenBaseDirectory, char *strIn, size_t lenIn, char *strOut, size_t lenOut);

#define CASE_SENSITIVE_NO	0	
#define CASE_SENSITIVE_YES	1

BOOL CheckMatch (char *strPattern, char *strName, int iCase);

#ifndef WIN32
int GetPrivateProfileString (char *lpAppName, char *lpKeyName, char *lpDefault, char *lpRetBuf, int nSize, char *lpFileName);
#endif

void CleanGlobalVars (char **buf, char *company, char *userid, char *sessionid);

int Pvx_compress (byte *bf_out, byte *bf_in, int len, int iCompress);
int Pvx_uncompress (byte *bf_out, int bf_out_len, byte *bf_in, int bf_in_len, int iCompress);


#if defined(PVK_LINUX) || defined(__IBMR6K__) || defined(__SCOUNX__) || defined(__SCO6__) || defined(__SUN__)
int memicmp (char *s1, char *s2, int n);
#if !defined(__SCOUNX__)
int strnicmp (char *s1, char *s2, int n);
#endif
#endif

char * stristr( const char * szStringToBeSearched, const char * szSubstringToSearchFor );

/* Memory allocation log */
/* #define TRACE_SVR 1 */
void PvxOutputDebugSvr (char *p);

#endif	/* _PVXSHARE_H_ */


